% demo_parallel_cs_no_perm.m
%
% Written: Hao Fang
% Created: Sep. 2012

% close all;
% clear;
clc;

path(path, '../Images');
path(path, '../Tools');

% filename = 'boat.512.tiff';
% filename = 'cameraman.tif';
% img = imread(filename);

filename = 'Peppers.tiff';
% filename = 'Lena.tiff';
img = imread(filename);
img = rgb2gray(img);

CR = 0.2:0.2:0.8;

% source signal: DCT2 coefficient of image
X = dct2(img);

rec_X = cell(1, length(CR));
rec_img = cell(1, length(CR));
PSNR = zeros(1, length(CR));
fprintf('demo parallel cs with no permutation\n');
for ii = 1:length(CR)
    fprintf('CR: %.1f\n', CR(ii));
    rec_X{ii} = parallel_cs_no_perm(X, CR(ii));
    rec_img{ii} = idct2(rec_X{ii});
    PSNR(ii) = psnr(double(img), double(rec_img{ii}));
end

save(sprintf('./Data/%s_noperm.mat', filename), 'PSNR', 'CR','filename');
